#include <p30fxxxx.h>
#include <outcompare.h>

/************************************************************************
*    Function Name:  ConfigIntOC1                                	*
*    Description:    This Function Configures Interrupt and sets        *
*                    Interrupt Priority                                 *
*    Parameters:     unsigned int config                                *
*    Return Value:   None                                               *
************************************************************************/

void ConfigIntOC1(unsigned int config)
{   
    IFS0bits.OC1IF = 0 ;                /* Clear IF bit */
    IPC0bits.OC1IP=(config &0x0007);    /* Assign Interrupt Priority */ 
    IEC0bits.OC1IE=(config &0x0008)>>3; /* Enable/disable Interrupt */ 
}
